<?php require("config.php"); include("inc/check_session.php");

if( isset($_GET['id']) and get_gall($_GET['id']) ){
	$gall_id = esc($_GET['id']);
	$RS_gall_images = get_gall($gall_id);
}else{
	die("Invalid Gallery!");
}

$_TITLE = "Images for ".$RS_gall_images['name'];
$_TOPBAR = true;
$_SIDEBAR = true;

require("inc/header.php");
?>

<script src="js/summernote.min.js"></script>
<script src="js/uniform.min.js"></script>

<script src="js/editor_summernote.js"></script>

<div class="page-header page-header-light">
	<div class="page-header-content header-elements-md-inline">
		<div class="page-title d-flex">
			<h4><i class="icon-image2 mr-2"></i> <span class="font-weight-semibold"><?php _e( $_TITLE ); ?></span></h4>
			<a href="#" class="header-elements-toggle text-default d-md-none"><i class="icon-more"></i></a>
		</div>

		<div class="header-elements d-none">
			<div class="d-flex justify-content-center">
				<button id="add-new" class="btn btn-link btn-float text-default"><i class="icon-plus3 text-primary"></i><span>Add New</span></button>
			</div>
		</div>
	</div>

	<div class="breadcrumb-line breadcrumb-line-light header-elements-md-inline">
		<div class="d-flex">
			<div class="breadcrumb">
				<a href="index.php" class="breadcrumb-item"><i class="icon-home2 mr-2"></i> Home</a>
				<a href="gall.php" class="breadcrumb-item">Galleries</a>
				<span class="breadcrumb-item active"><?php _e( $RS_gall_images['name'] ); ?></span>
			</div>
		</div>
	</div>
</div>

<div class="content">

	<?php if( isset($_GET['mess']) and !empty($_GET['mess']) ){ ?>
	<div class="alert text-violet-800 alpha-violet alert-dismissible">
		<button type="button" class="close" data-dismiss="alert"><span>×</span></button>
		<?php _e( $_GET['mess'] ); ?>
	</div>
	<?php } ?>

	<div id="add-new-card" class="card" style="display:none;">
		<div class="card-header header-elements-inline">
			<h5 class="card-title">Add New Image</h5>
		</div>
		<div class="card-body">
				
			<form action="mini_process.php" method="post" enctype="multipart/form-data">

				<input type="hidden" name="p" value="AddGallImage">
				<input type="hidden" name="gall_id" value="<?php _e($gall_id); ?>">
				
				<div class="form-group row">
					<label for="name" class="col-form-label col-md-2">Name:</label>
					<div class="col-md-10">
						<input id="name" name="name" class="form-control" type="text" required>
					</div>
				</div>

				<div class="form-group row">
					<label for="image" class="col-form-label col-md-2">Image</label>
					<div class="col-md-10">
						<div class="custom-file">
							<input type="file" class="custom-file-input" id="image" name="image">
							<label class="custom-file-label" for="image">Choose file...</label>
						</div>
					</div>
				</div>

				<div class="form-group row">
					<label for="text" class="col-form-label col-md-2">Text:</label>
					<div class="col-md-10">
						<textarea id="text" name="text" class="summernote"></textarea>
					</div>
				</div>

				<div class="form-group row">
					<div class="col-md-2"></div>
					<div class="col-md-10"><button type="submit" id="edit" class="btn btn-primary"><i class="icon-floppy-disk mr-2"></i> Save</button></div>
				</div>

			</form>

		</div>
	</div>

	<div class="card">

		<div class="card-body">
			Total of <?php $images = db_result(db_query("SELECT count(*) FROM `gall_images` WHERE `gall_id`=".$gall_id),0); _e( appendzero($images) ); ?> images found!
		</div>

		<?php
		$gall_image_top_rank = top_rank('gall_images', "`gall_id`=".$gall_id);
        $gall_image_bottom_rank = bottom_rank('gall_images', "`gall_id`=".$gall_id);
        $gall_image_query = db_query("SELECT * FROM `gall_images` WHERE `gall_id`=".$gall_id." ORDER BY `rank` ASC");
        if( db_num_rows($gall_image_query) > 0 ){
		?>
		<div class="table-responsive">
			<table class="table table-striped table-hover">
				
				<thead>
					<tr>
						<th class="text-center" style="width:150px;">Image</th>
						<th>Name</th>
						<th class="text-center" style="width:80px;">Show</th>
						<th class="text-center" style="width:100px;">Rank</th>
						<th class="text-center" style="width:100px;">Options</th>
					</tr>
				</thead>

				<tbody>
					
					<?php while($RS_gall_image = db_fetch_array($gall_image_query)){ ?>
					<tr>

						<td class="text-center">
							<?php if( !empty($RS_gall_image['image']) ){ ?><a href="<?php _e($__url_gallery.$RS_gall_image['image']); ?>" target="_blank">
								<img style="max-width:100%;" class="rounded mx-auto d-block img-fluid img-thumbnail" src="<?php _e($__url_gallery.'s-'.$RS_gall_image['image']); ?>" alt="">
							</a><?php } ?>
						</td>
						
						<td>
							<strong><?php _e( $RS_gall_image['name'] ); ?></strong>
						</td>

						<td>
							<?php if( $RS_gall_image['show']=="y" ){ ?>
								<a class="btn btn-sm bg-green-400" href="mini_process.php?p=dgallimage&id=<?php _e($RS_gall_image['id']); ?>" title="Click to Hide">Yes</a>
							<?php }else{ ?>
								<a class="btn btn-sm bg-purple-400" href="mini_process.php?p=dgallimage&id=<?php _e($RS_gall_image['id']); ?>" title="Click to Show">No</a>
							<?php } ?>
						</td>

						<td class="text-center">
							<div class="btn-group" role="group">


								<?php if( $RS_gall_image['rank'] == $gall_image_top_rank ){ ?>
									<button type="button" class="btn btn-sm bg-secondary">
								<?php }else{ ?>
									<a class="btn btn-sm bg-teal-400" href="mini_process.php?p=gallimagerank&id=<?php _e($RS_gall_image['id']); ?>&gall_id=<?php _e($gall_id); ?>&r=up">
								<?php } ?>
									<i class="icon-arrow-up5"></i>
								<?php if( $RS_gall_image['rank'] == $gall_image_top_rank ){ ?>
									</button>
								<?php }else{ ?>
									</a>
								<?php } ?>

								<?php if( $RS_gall_image['rank'] == $gall_image_bottom_rank ){ ?>
									<button type="button" class="btn btn-sm bg-secondary">
								<?php }else{ ?>
									<a class="btn btn-sm bg-teal-400" href="mini_process.php?p=gallimagerank&id=<?php _e($RS_gall_image['id']); ?>&gall_id=<?php _e($gall_id); ?>&r=down">
								<?php } ?>
									<i class="icon-arrow-down5"></i>
								<?php if( $RS_gall_image['rank'] == $gall_image_bottom_rank ){ ?>
								 	</button>
								<?php }else{ ?>
									</a>
								<?php } ?>

							</div>
						</td>

						<td class="text-center">
							<form action="mini_process.php" method="post" onSubmit="javascript: if(confirm('Are you sure you want to delete this?')) return true; else return false; ">
								<input type="hidden" name="p" value="DelGallImage">
								<input type="hidden" name="id" value="<?php _e($RS_gall_image['id']); ?>">
								<input type="hidden" name="gall_id" value="<?php _e($gall_id); ?>">
								<div class="btn-group" role="group">
									<a href="edit_gall_images.php?id=<?php _e($RS_gall_image['id']); ?>" class="btn btn-sm bg-indigo-400"><i class="icon-pencil"></i></a>
									<button type="submit" class="btn btn-sm bg-blue-400"><i class="icon-bin"></i></button>
								</div>
							</form>
						</td>

					</tr>
					<?php } ?>

				</tbody>

			</table>
		</div>
		<?php } ?>

	</div>

</div>

<script type="text/javascript">
$(document).ready(function(){
	$("#add-new").click(function(){
	    $("#add-new-card").toggle();
	});
});
</script>

<?php require("inc/footer.php"); ?>